
#ifndef _____PRO_FACE___MTOM_SIO_MEMORYLINK_CLASS_HEADER_FILE____
#define _____PRO_FACE___MTOM_SIO_MEMORYLINK_CLASS_HEADER_FILE____

#define MEMLNK_DEF_BUFFER_SIZE				8192
#define MEMLNK_DEF_STX						0x02	// start of message
#define MEMLNK_DEF_ETX						0x03	// end of message
#define MEMLNK_DEF_ENQ						0x05
#define MEMLNK_DEF_ACK						0x06	// success
#define MEMLNK_DEF_LF						0x0A	// text terminator
#define MEMLNK_DEF_CR						0x0D	// text terminator
#define MEMLNK_DEF_NAK						0x15	// error
#define MEMLNK_DEF_ESC						0x1B	// start of command
#define MEMLNK_DEF_DLE						0x10	// start of command
#define MEMLNK_DEF_FS						0x1C	// polling command

typedef BOOL (CALLBACK* MTOMSIOCALLBACK)(LPVOID,int*,int*,LPVOID);
#define MEMLNK_TIMEOUT_TICK					10000	//	3sec

typedef struct tagR_REPLY
{
	INT		iDataCount ;
	WORD*	pwData ;
} MEMLNK_ST_R_REPLY ;


typedef struct tagI_REPLY
{
	WORD	wCount ;
	WORD	wData ;
} MEMLNK_ST_I_REPLY ;


typedef struct tagCONTRAST_REPLY
{
	WORD	wContrast ;
	WORD	wBright ;
} MEMLNK_ST_CONTRAST_REPLY ;

class CMemlinkSio
{
public:
	CMemlinkSio(LPMtoMSioConfig pstConfig);
	~CMemlinkSio(void);

	bool IsOpen(void);
	bool Open(void) ;
	void Close(void) ;

	int ESC_W(WORD wAddress,INT iDataCount,WORD* pwData)	;
	int ESC_R(WORD wAddress,INT iDataCount,WORD* pwoData)	;
	int ESC_T(GPCOLOR cDisplayColor,GPCOLOR cBackColor, INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString)	;
	int ESC_L(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2);
	int ESC_B(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2);
	int ESC_S(GPCOLOR cDisplayColor,GPCOLOR cBackColor,INT iX1,INT iY1,INT iX2,INT iY2,GPTILE cTile);
	int ESC_C(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius);
	int ESC_A(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle);
	int ESC_G(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle);
	int ESC_I(BOOL* pbHave,DWORD *pdwCode);
	int ESC_t(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPFONT cFont,INT iTurn,INT iDirection,INT iHalfcentering,INT iEmphasis,GPCOLOR cSculptrue,INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString);
	int ESC_l(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iArrowPattern,INT iArrowDirection,INT iX1,INT iY1,INT iX2,INT iY2);
	int ESC_b(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2);
	int ESC_s(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2);
	int ESC_c(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iX1,INT iY1,INT iRadius);
	int ESC_g(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle);
	int ESC_SetContrast(DWORD dwContrast,DWORD dwLight) ;
	int ESC_GetContrast(DWORD *dwContrast,DWORD *dwLight) ;
	int ESC_Y(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iPosCount,INT* piX,INT* piY) ;
	int ESC_y(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iPosCount,INT* piX,INT* piY);
	int ESC_M(GPCOLOR cDisplayColor,GPCOLOR cBackColor,BYTE bFontType,WORD wLanguage,BYTE bPriority,WCHAR* szString) ;
	int ESC_m(void);

	int GetLastError() ;
	
	BOOL ReceiveAckNak(int* piRet,int* piDetail) ;
	BOOL ReceiveContrast(int* piRet,int* piDetail, MEMLNK_ST_CONTRAST_REPLY* pstReply) ;
	BOOL ReceiveRead(int* piRet,int* piDetail, MEMLNK_ST_R_REPLY* pstReply) ;
	BOOL ReceiveInterrupt(int* piRet,int* piDetail, MEMLNK_ST_I_REPLY* pstReply) ;

private :
	INT AddHead(BYTE* TxBuf) ;
	INT AddFoot(BYTE* TxBuf, INT iLen) ;
	int Transmit(BYTE* Buf, INT iLen, MTOMSIOCALLBACK pfReceive, LPVOID pParam) ;
	BYTE CalculateChecksum(BYTE* Buffer, INT iLen) ;
	INT Dualization(BYTE* SrcBuf, INT iSrcLen, BYTE* DestBuf) ;
	INT ExpDualization(BYTE* SrcBuf, INT iSrcLen, BYTE* DestBuf) ;
	INT ShiftBuffer(BYTE* Buf, INT iLen, INT iShiftLen) ;
	INT AsciiColor(GPCOLOR cColor,BYTE* Buf) ;
	INT AsciiColorEx(GPCOLOR cColor,BYTE* Buf) ;
	INT AsciiDec(INT iNum,INT iLen,BYTE* Buf) ;
	INT AsciiHex(INT iNum,INT iLen,BYTE* Buf) ;

	int ESC_SetContrast_Sub(WORD wAttribute,WORD wValue) ;

	BOOL ReceiveAck(BYTE* pBuffer,int iLength, int *pDelLen) ;
	BOOL ReceiveAckAscii(BYTE* pBuffer,int iLength, int *pDelLen) ;
	BOOL ReceiveAckBin(BYTE* pBuffer,int iLength, int *pDelLen) ;

	BOOL ReceiveNak(BYTE* pBuffer,int iLength, BYTE* pbyErr, int *pDelLen) ;
	BOOL ReceiveNakAscii(BYTE* pBuffer,int iLength, BYTE* pbyErr, int *pDelLen) ;
	BOOL ReceiveNakBin(BYTE* pBuffer,int iLength, BYTE* pbyErr, int *pDelLen) ;

	BOOL ReceiveContrastAscii(BYTE* pBuffer,int iLength, MEMLNK_ST_CONTRAST_REPLY* pstReply, int *pDelLen) ;
	BOOL ReceiveContrastBin(BYTE* pBuffer,int iLength, MEMLNK_ST_CONTRAST_REPLY* pstReply, int *pDelLen) ;

	BOOL ReceiveReadAscii(BYTE* pBuffer,int iLength, MEMLNK_ST_R_REPLY* pstReply, int *pDelLen) ;
	BOOL ReceiveReadBin(BYTE* pBuffer,int iLength, MEMLNK_ST_R_REPLY* pstReply, int *pDelLen) ;

	BOOL ReceiveInterruptAscii(BYTE* pBuffer,int iLength, MEMLNK_ST_I_REPLY* pstReply, int *pDelLen) ;
	BOOL ReceiveInterruptBin(BYTE* pBuffer,int iLength, MEMLNK_ST_I_REPLY* pstReply, int *pDelLen) ;
	
	BOOL CheckMachineNum(BYTE* pBuffer) ;

	BOOL GetAsciiPacket(BYTE* SrcBuf, INT iSrcLen, INT *piStart, INT* piLen) ;
	BOOL GetBinPacket(BYTE* SrcBuf, INT iSrcLen, INT *piStart, INT* piLen) ;

private :
	CSioSock* m_pSock ;
	MtoMSioSetting m_stSetting ;

	BYTE m_RxBuf[MEMLNK_DEF_BUFFER_SIZE*2] ;
	INT m_iRxLen ;
	int m_iErrDetail ;
};

#endif //	_____PRO_FACE___MTOM_SIO_MEMORYLINK_CLASS_HEADER_FILE____